IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Localidades_Ocupadas') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Localidades_Ocupadas
END
GO

CREATE FUNCTION [dbo].[CF_Localidades_Ocupadas](@pId_Sector SMALLINT, @pFecha DATETIME, @pId_Lista_Precio_Evento SMALLINT)
RETURNS INT
AS
BEGIN
DECLARE @Cantidad_Localidades_Ocupadas	INT

-------------------------------------------------------------------------------------------------------------------------------------

SET @Cantidad_Localidades_Ocupadas = 0

IF (@pId_Lista_Precio_Evento > 0)
BEGIN
	--WHERE no toma la fecha y filtra B.Id_Lista
	SET @Cantidad_Localidades_Ocupadas =	ISNULL((SELECT COUNT(*) 
													FROM Cbtes_Items A, Cbtes B, Cbtes_Tipos C, Productos P
													WHERE 
													A.Id_Trans = B.Id_Trans
													AND B.Id_Tipo_Cbte = C.Id_Tipo_Cbte
													AND A.Id_Producto = P.Id_Producto
													AND A.Flag_QA = 'A' 
													AND B.Id_Estado_Cbte <> 3 
													AND B.Id_Estado_Cbte <> 0
													AND (C.Compromete_Factura = 1 OR C.Compromete_Remitos = 1 OR C.Compromete_Pedido = 1)
													AND B.Id_Lista = @pId_Lista_Precio_Evento
													AND P.Tipo = 'L'
													AND P.Id_Sector = @pId_Sector)
													, 0)
END
ELSE
BEGIN
	--WHERE toma la fecha y no filtra B.Id_Lista
	SET @Cantidad_Localidades_Ocupadas =	ISNULL((SELECT COUNT(*) 
													FROM Cbtes_Items A, Cbtes B, Cbtes_Tipos C, Productos P
													WHERE 
													A.Id_Trans = B.Id_Trans
													AND B.Id_Tipo_Cbte = C.Id_Tipo_Cbte
													AND A.Id_Producto = P.Id_Producto
													AND A.Flag_QA = 'A' 
													AND B.Id_Estado_Cbte <> 3 
													AND B.Id_Estado_Cbte <> 0
													AND (C.Compromete_Factura = 1 OR C.Compromete_Remitos = 1 OR C.Compromete_Pedido = 1)
													AND A.Fecha_QA < CONVERT(DATE, DATEADD(DAY, 1, @pFecha))
													AND A.Fecha_Venc >= CONVERT(DATE, @pFecha)
													AND P.Tipo = 'L'
													AND P.Id_Sector = @pId_Sector)
													, 0)
END

-------------------------------------------------------------------------------------------------------------------------------------

RETURN ISNULL(@Cantidad_Localidades_Ocupadas, 0)
END
